/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.afu.annotator.scanner.CommonScanner;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

public class InstanceOfScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToInstanceOfOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfInstanceOfTree(TreePath origpath, Tree tree) {
        TreePath path = TreePathUtil.findCountingContext(origpath);
        if (path == null) {
            return -1;
        }
        InstanceOfScanner ios = new InstanceOfScanner(tree);
        ios.scan(path, null);
        return ios.index;
    }

    private InstanceOfScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void p) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitInstanceOf(node, null);
    }

    public static void addInstanceOfToMethod(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToInstanceOfOffsets.get(methodName);
        if (offsetList == null) {
            offsetList = new ArrayList<Integer>();
            methodNameToInstanceOfOffsets.put(methodName, offsetList);
        }
        offsetList.add(offset);
    }

    public static Integer getMethodInstanceOfIndex(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToInstanceOfOffsets.get(methodName);
        if (offsetList == null) {
            return -1;
        }
        return offsetList.indexOf(offset);
    }
}

