/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Insertion;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.org.plumelib.util.IPair;

public class AnnotationInsertion
extends Insertion {
    private final String fullyQualifiedAnnotationText;
    private final String fullyQualifiedAnnotationName;
    private final Annotation annotation;
    private String type;
    private boolean generateBound;
    private boolean generateExtends;
    private boolean wasGenerateExtends;

    public AnnotationInsertion(String fullyQualifiedAnnotationText, Criteria criteria, boolean separateLine) {
        this(fullyQualifiedAnnotationText, criteria, separateLine, null);
    }

    public AnnotationInsertion(String fullyQualifiedAnnotationText, Criteria criteria, boolean separateLine, Annotation annotation) {
        super(criteria, separateLine);
        assert (fullyQualifiedAnnotationText.startsWith("@")) : fullyQualifiedAnnotationText;
        this.fullyQualifiedAnnotationText = fullyQualifiedAnnotationText;
        this.fullyQualifiedAnnotationName = this.extractAnnotationFullyQualifiedName();
        this.annotation = annotation;
        this.type = null;
        this.generateBound = false;
        this.generateExtends = false;
        this.wasGenerateExtends = false;
    }

    public AnnotationInsertion(String annotation) {
        this(annotation, new Criteria(), false);
    }

    public boolean isGenerateExtends() {
        return this.generateExtends;
    }

    public boolean isGenerateBound() {
        return this.generateBound;
    }

    public void setGenerateExtends(boolean generateExtends) {
        this.generateExtends = generateExtends;
        this.wasGenerateExtends |= generateExtends;
    }

    public void setGenerateBound(boolean b) {
        this.generateBound = b;
    }

    @Override
    protected String getText(boolean abbreviate) {
        String result = this.fullyQualifiedAnnotationText;
        if (abbreviate) {
            IPair<String, String> ps = AnnotationInsertion.removePackage(result);
            String packageName = (String)ps.first;
            if (packageName != null) {
                this.packageNames.add(packageName);
                result = (String)ps.second;
            }
        }
        if (!result.startsWith("@")) {
            throw new Error("Illegal insertion, must start with @: " + result);
        }
        if (this.type != null) {
            result = "new " + result + " " + this.type;
        } else if (this.generateBound) {
            result = result + " Object &";
        } else if (this.generateExtends) {
            result = " extends " + result + " Object";
        }
        return result;
    }

    private String extractAnnotationFullyQualifiedName() {
        assert (this.fullyQualifiedAnnotationText.startsWith("@"));
        int nameBegin = 1;
        int nameEnd = this.fullyQualifiedAnnotationText.indexOf("(");
        if (nameEnd == -1) {
            nameEnd = this.fullyQualifiedAnnotationText.length();
        }
        return this.fullyQualifiedAnnotationText.substring(nameBegin, nameEnd);
    }

    public String getAnnotationText() {
        return this.fullyQualifiedAnnotationText;
    }

    public String getAnnotationFullyQualifiedName() {
        return this.fullyQualifiedAnnotationName;
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        if (this.generateExtends || precedingChar == '.') {
            return false;
        }
        return super.addLeadingSpace(gotSeparateLine, pos, precedingChar);
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return !this.wasGenerateExtends && super.addTrailingSpace(gotSeparateLine);
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.ANNOTATION;
    }

    @Override
    public String toString() {
        return this.fullyQualifiedAnnotationText + " " + super.toStringWithoutClass();
    }

    public void setType(String s) {
        this.type = s;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

