/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.hql.ParserHelper;
import net.sf.hibernate.hql.PreprocessingParser;
import net.sf.hibernate.impl.IteratorImpl;
import net.sf.hibernate.impl.ScrollableResultsImpl;
import net.sf.hibernate.loader.Loader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.sql.ForUpdateFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.QueryJoinFragment;
import net.sf.hibernate.sql.QuerySelect;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PrimitiveType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTranslator
extends Loader {
    private final Map typeMap = new SequencedHashMap();
    private final Map collections = new SequencedHashMap();
    private List returnTypes = new ArrayList();
    private final List fromTypes = new ArrayList();
    private final List scalarTypes = new ArrayList();
    private final Map namedParameters = new HashMap();
    private final Map aliasNames = new HashMap();
    private final Set crossJoins = new HashSet();
    private final List scalarSelectTokens = new ArrayList();
    private final List whereTokens = new ArrayList();
    private final List havingTokens = new ArrayList();
    private final Map joins = new HashMap();
    private final List orderByTokens = new ArrayList();
    private final List groupByTokens = new ArrayList();
    private final Set identifierSpaces = new HashSet();
    private final Set entitiesToFetch = new HashSet();
    private Queryable[] persisters;
    private String[] names;
    private boolean[] includeInSelect;
    private int selectLength;
    private Type[] types;
    private String[][] scalarColumnNames;
    private SessionFactoryImplementor factory;
    private Map tokenReplacements;
    private int nameCount = 0;
    private int parameterCount = 0;
    private String queryString;
    private boolean distinct = false;
    private boolean compiled;
    private String sqlString;
    private Class holderClass;
    private Constructor holderConstructor;
    private boolean hasScalars;
    private boolean shallowQuery;
    private QueryTranslator superQuery;
    private CollectionPersister collectionPersister;
    private int collectionOwnerColumn = -1;
    private String collectionOwnerName;
    private String fetchName;
    private String[] suffixes;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$hql$QueryTranslator == null ? (class$net$sf$hibernate$hql$QueryTranslator = QueryTranslator.class$("net.sf.hibernate.hql.QueryTranslator")) : class$net$sf$hibernate$hql$QueryTranslator));
    private final Map pathAliases = new HashMap();
    private final Map pathJoins = new HashMap();
    private static final Set BEFORE_CLASS_TOKENS = new HashSet();
    private static final Set NOT_AFTER_CLASS_TOKENS = new HashSet();
    static /* synthetic */ Class class$net$sf$hibernate$hql$QueryTranslator;

    void compile(QueryTranslator superquery, String queryString) throws QueryException, MappingException {
        this.factory = superquery.factory;
        this.tokenReplacements = superquery.tokenReplacements;
        this.superQuery = superquery;
        this.shallowQuery = true;
        this.compile(queryString);
    }

    public synchronized void compile(SessionFactoryImplementor factory, String queryString, Map replacements, boolean scalar) throws QueryException, MappingException {
        if (!this.compiled) {
            this.factory = factory;
            this.tokenReplacements = replacements;
            this.shallowQuery = scalar;
            this.compile(queryString);
        }
    }

    private void compile(String queryString) throws QueryException, MappingException {
        this.queryString = queryString;
        log.trace((Object)"compiling query");
        try {
            ParserHelper.parse(new PreprocessingParser(this.tokenReplacements), queryString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", this);
            this.renderSQL();
        }
        catch (QueryException qe) {
            qe.setQueryString(queryString);
            throw qe;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.debug((Object)"unexpected query compilation problem", (Throwable)e);
            QueryException qe = new QueryException("Incorrect query syntax", e);
            qe.setQueryString(queryString);
            throw qe;
        }
        this.postInstantiate();
        this.compiled = true;
    }

    public Loadable[] getPersisters() {
        return this.persisters;
    }

    public Type[] getReturnTypes() {
        return this.types;
    }

    protected boolean hasScalarValues() {
        return this.hasScalars;
    }

    public String[][] getScalarColumnNames() {
        return this.scalarColumnNames;
    }

    private void logQuery(String hql, String sql) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HQL: " + hql));
            log.debug((Object)("SQL: " + sql));
        }
    }

    void setAliasName(String alias, String name) {
        this.aliasNames.put(alias, name);
    }

    String getAliasName(String alias) {
        String name = (String)this.aliasNames.get(alias);
        if (name == null) {
            name = this.superQuery != null ? this.superQuery.getAliasName(alias) : alias;
        }
        return name;
    }

    String unalias(String path) {
        String alias = StringHelper.root(path);
        String name = this.getAliasName(alias);
        if (name != null) {
            return name + path.substring(alias.length());
        }
        return path;
    }

    void addEntityToFetch(String name) {
        this.entitiesToFetch.add(name);
    }

    protected String getSQLString() {
        this.logQuery(this.queryString, this.sqlString);
        return this.sqlString;
    }

    private int nextCount() {
        int n;
        if (this.superQuery == null) {
            int n2 = this.nameCount;
            n = n2;
            this.nameCount = n2 + 1;
        } else {
            int n3 = this.superQuery.nameCount;
            n = n3;
            this.superQuery.nameCount = n3 + 1;
        }
        return n;
    }

    private String createName(String description) {
        return new Alias(10, Integer.toString(this.nextCount()) + '_').toAliasString(StringHelper.unqualify(description).toLowerCase());
    }

    String createNameFor(Class type) {
        return this.createName(type.getName());
    }

    String createNameForCollection(String role) {
        return this.createName(role);
    }

    Class getType(String name) {
        Class type = (Class)this.typeMap.get(name);
        if (type == null && this.superQuery != null) {
            type = this.superQuery.getType(name);
        }
        return type;
    }

    String getRole(String name) {
        String role = (String)this.collections.get(name);
        if (role == null && this.superQuery != null) {
            role = this.superQuery.getRole(name);
        }
        return role;
    }

    boolean isName(String name) {
        return this.aliasNames.containsKey(name) || this.typeMap.containsKey(name) || this.collections.containsKey(name) || this.superQuery != null && this.superQuery.isName(name);
    }

    Queryable getPersisterForName(String name) throws QueryException {
        Class type = this.getType(name);
        if (type == null) {
            Type elemType = this.getCollectionPersister(this.getRole(name)).getElementType();
            if (!(elemType instanceof EntityType)) {
                return null;
            }
            return this.getPersister(((EntityType)elemType).getPersistentClass());
        }
        Queryable persister = this.getPersister(type);
        if (persister == null) {
            throw new QueryException("persistent class not found: " + type.getName());
        }
        return persister;
    }

    Queryable getPersisterUsingImports(String className) {
        try {
            return (Queryable)this.factory.getPersister(this.factory.getImportedClassName(className));
        }
        catch (MappingException me) {
            return null;
        }
    }

    Queryable getPersister(Class clazz) throws QueryException {
        try {
            return (Queryable)this.factory.getPersister(clazz);
        }
        catch (Exception e) {
            throw new QueryException("persistent class not found: " + clazz.getName());
        }
    }

    CollectionPersister getCollectionPersister(String role) throws QueryException {
        try {
            return this.factory.getCollectionPersister(role);
        }
        catch (Exception e) {
            throw new QueryException("collection role not found: " + role);
        }
    }

    void addType(String name, Class type) {
        this.typeMap.put(name, type);
    }

    void addCollection(String name, String role) {
        this.collections.put(name, role);
    }

    void addFrom(String name, Class type, JoinFragment join) {
        this.addType(name, type);
        this.addFrom(name, join);
    }

    void addFrom(String name, JoinFragment join) {
        this.fromTypes.add(name);
        this.addJoin(name, join);
    }

    void addFromClass(String name, Queryable classPersister) {
        QueryJoinFragment ojf = this.createJoinFragment();
        ((JoinFragment)ojf).addCrossJoin(classPersister.getTableName(), name);
        this.crossJoins.add(name);
        this.addFrom(name, classPersister.getMappedClass(), ojf);
    }

    void addSelectClass(String name) {
        this.returnTypes.add(name);
    }

    void addSelectScalar(Type type) {
        this.scalarTypes.add(type);
    }

    void appendWhereToken(String token) {
        this.whereTokens.add(token);
    }

    void appendHavingToken(String token) {
        this.havingTokens.add(token);
    }

    void appendOrderByToken(String token) {
        this.orderByTokens.add(token);
    }

    void appendGroupByToken(String token) {
        this.groupByTokens.add(token);
    }

    void appendScalarSelectToken(String token) throws QueryException {
        this.scalarSelectTokens.add(token);
    }

    void appendScalarSelectTokens(String[] tokens) throws QueryException {
        this.scalarSelectTokens.add(tokens);
    }

    void addJoin(String name, JoinFragment newjoin) {
        if (!this.joins.containsKey(name)) {
            this.joins.put(name, newjoin);
        }
    }

    void addNamedParameter(String name) {
        if (this.superQuery != null) {
            this.superQuery.addNamedParameter(name);
        }
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((ArrayList)o).add(loc);
        }
    }

    protected int[] getNamedParameterLocs(String name) throws QueryException {
        Object o = this.namedParameters.get(name);
        if (o == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name);
            qe.setQueryString(this.queryString);
            throw qe;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return ArrayHelper.toIntArray((ArrayList)o);
    }

    public Collection getNamedParameters() {
        return this.namedParameters.keySet();
    }

    public static String scalarName(int x, int y) {
        return "" + 'x' + x + '_' + y + '_';
    }

    private void renderSQL() throws QueryException, MappingException {
        Object p;
        int rtsize;
        if (this.returnTypes.size() == 0 && this.scalarTypes.size() == 0) {
            this.returnTypes = this.fromTypes;
            rtsize = this.returnTypes.size();
        } else {
            rtsize = this.returnTypes.size();
            Iterator iter = this.entitiesToFetch.iterator();
            while (iter.hasNext()) {
                this.returnTypes.add(iter.next());
            }
        }
        int size = this.returnTypes.size();
        this.persisters = new Queryable[size];
        this.names = new String[size];
        this.suffixes = new String[size];
        this.includeInSelect = new boolean[size];
        int i = 0;
        while (i < size) {
            String name = (String)this.returnTypes.get(i);
            this.persisters[i] = this.getPersisterForName(name);
            this.suffixes[i] = size == 1 ? "" : Integer.toString(i) + '_';
            this.names[i] = name;
            boolean bl = this.includeInSelect[i] = !this.entitiesToFetch.contains(name);
            if (this.includeInSelect[i]) {
                ++this.selectLength;
            }
            if (name.equals(this.collectionOwnerName)) {
                this.collectionOwnerColumn = i;
            }
            ++i;
        }
        String scalarSelect = this.renderScalarSelect();
        int scalarSize = this.scalarTypes.size();
        this.hasScalars = this.scalarTypes.size() != rtsize;
        this.types = new Type[scalarSize];
        int i2 = 0;
        while (i2 < scalarSize) {
            this.types[i2] = (Type)this.scalarTypes.get(i2);
            ++i2;
        }
        QuerySelect sql = new QuerySelect(this.factory.getDialect());
        sql.setDistinct(this.distinct);
        if (!this.shallowQuery) {
            this.renderIdentifierSelect(sql);
            this.renderPropertiesSelect(sql);
        }
        if (this.collectionPersister != null) {
            sql.addSelectFragmentString(this.collectionPersister.multiselectClauseFragment(this.fetchName));
        }
        if (this.hasScalars || this.shallowQuery) {
            sql.addSelectFragmentString(scalarSelect);
        }
        this.mergeJoins(sql.getJoinFragment());
        sql.setWhereTokens(this.whereTokens.iterator());
        sql.setGroupByTokens(this.groupByTokens.iterator());
        sql.setHavingTokens(this.havingTokens.iterator());
        sql.setOrderByTokens(this.orderByTokens.iterator());
        if (this.collectionPersister != null && this.collectionPersister.hasOrdering()) {
            sql.addOrderBy(this.collectionPersister.getSQLOrderByString(this.fetchName));
        }
        this.scalarColumnNames = QueryTranslator.generateColumnNames(this.types, this.factory);
        Iterator<Object> iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            p = this.getCollectionPersister((String)iter.next());
            this.addIdentifierSpace((Serializable)((Object)((CollectionPersister)p).getQualifiedTableName()));
        }
        iter = this.typeMap.keySet().iterator();
        while (iter.hasNext()) {
            p = this.getPersisterForName((String)iter.next());
            this.addIdentifierSpace(p.getIdentifierSpace());
        }
        this.sqlString = sql.toQueryString();
        Class[] classes = new Class[this.types.length];
        int i3 = 0;
        while (i3 < this.types.length) {
            if (this.types[i3] != null) {
                classes[i3] = this.types[i3] instanceof PrimitiveType ? ((PrimitiveType)this.types[i3]).getPrimitiveClass() : this.types[i3].getReturnedClass();
            }
            ++i3;
        }
        try {
            if (this.holderClass != null) {
                this.holderConstructor = this.holderClass.getConstructor(classes);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new QueryException("could not find constructor for: " + this.holderClass.getName(), nsme);
        }
    }

    private void renderIdentifierSelect(QuerySelect sql) {
        int size = this.returnTypes.size();
        int k = 0;
        while (k < size) {
            String name = (String)this.returnTypes.get(k);
            String suffix = size == 1 ? "" : Integer.toString(k) + '_';
            sql.addSelectFragmentString(this.persisters[k].identifierSelectFragment(name, suffix));
            ++k;
        }
    }

    private void renderPropertiesSelect(QuerySelect sql) {
        int size = this.returnTypes.size();
        int k = 0;
        while (k < size) {
            String suffix = size == 1 ? "" : Integer.toString(k) + '_';
            String name = (String)this.returnTypes.get(k);
            sql.addSelectFragmentString(this.persisters[k].propertySelectFragment(name, suffix));
            ++k;
        }
    }

    private String renderScalarSelect() {
        boolean isSubselect = this.superQuery != null;
        StringBuffer buf = new StringBuffer(20);
        if (this.scalarTypes.size() == 0) {
            int size = this.returnTypes.size();
            int k = 0;
            while (k < size) {
                this.scalarTypes.add(Hibernate.entity(this.persisters[k].getMappedClass()));
                String[] idColumnNames = this.persisters[k].getIdentifierColumnNames();
                int i = 0;
                while (i < idColumnNames.length) {
                    buf.append(this.returnTypes.get(k)).append('.').append(idColumnNames[i]);
                    if (!isSubselect) {
                        buf.append(" as ").append(QueryTranslator.scalarName(k, i));
                    }
                    if (i != idColumnNames.length - 1 || k != size - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                ++k;
            }
        } else {
            Iterator iter = this.scalarSelectTokens.iterator();
            int c = 0;
            boolean nolast = false;
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next instanceof String) {
                    String token = (String)next;
                    String lc = token.toLowerCase();
                    if (lc.equals(", ")) {
                        if (nolast) {
                            nolast = false;
                        } else if (!isSubselect) {
                            buf.append(" as ").append(QueryTranslator.scalarName(c++, 0));
                        }
                    }
                    buf.append(token);
                    if (!lc.equals("distinct") && !lc.equals("all")) continue;
                    buf.append(' ');
                    continue;
                }
                nolast = true;
                String[] tokens = (String[])next;
                int i = 0;
                while (i < tokens.length) {
                    buf.append(tokens[i]);
                    if (!isSubselect) {
                        buf.append(" as ").append(QueryTranslator.scalarName(c, i));
                    }
                    if (i != tokens.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                ++c;
            }
            if (!isSubselect && !nolast) {
                buf.append(" as ").append(QueryTranslator.scalarName(c++, 0));
            }
        }
        return buf.toString();
    }

    private JoinFragment mergeJoins(JoinFragment ojf) throws MappingException, QueryException {
        Iterator iter = this.typeMap.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Queryable p = this.getPersisterForName(name);
            boolean includeSubclasses = this.returnTypes.contains(name) && !this.isShallowQuery();
            JoinFragment join = (JoinFragment)this.joins.get(name);
            if (join == null) continue;
            boolean isCrossJoin = this.crossJoins.contains(name);
            ojf.addFragment(join);
            ojf.addJoins(p.fromJoinFragment(name, isCrossJoin, includeSubclasses), p.queryWhereFragment(name, isCrossJoin, includeSubclasses));
        }
        iter = this.collections.keySet().iterator();
        while (iter.hasNext()) {
            JoinFragment collJoin = (JoinFragment)this.joins.get((String)iter.next());
            if (collJoin == null) continue;
            ojf.addFragment(collJoin);
        }
        return ojf;
    }

    public Set getQuerySpaces() {
        return this.identifierSpaces;
    }

    public boolean isShallowQuery() {
        return this.shallowQuery;
    }

    void addIdentifierSpace(Serializable table) {
        this.identifierSpaces.add(table);
        if (this.superQuery != null) {
            this.superQuery.addIdentifierSpace(table);
        }
    }

    void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    void setCollectionToFetch(String role, String name, String ownerName) throws QueryException {
        this.fetchName = name;
        this.collectionPersister = this.getCollectionPersister(role);
        this.collectionOwnerName = ownerName;
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    protected void addFromCollection(String elementName, String collectionRole) throws QueryException {
        String collectionName;
        Type collectionElementType = this.getCollectionPersister(collectionRole).getElementType();
        if (!collectionElementType.isEntityType()) {
            throw new QueryException("collection of values in filter: " + elementName);
        }
        EntityType elemType = (EntityType)collectionElementType;
        CollectionPersister persister = this.getCollectionPersister(collectionRole);
        String[] keyColumnNames = persister.getKeyColumnNames();
        QueryJoinFragment join = this.createJoinFragment();
        if (persister.isOneToMany()) {
            collectionName = elementName;
        } else {
            collectionName = this.createNameForCollection(collectionRole);
            this.addCollection(collectionName, collectionRole);
            Queryable p = this.getPersister(elemType.getPersistentClass());
            String[] idColumnNames = p.getIdentifierColumnNames();
            String[] eltColumnNames = persister.getElementColumnNames();
            ((JoinFragment)join).addJoin(p.getTableName(), elementName, StringHelper.prefix(eltColumnNames, collectionName + '.'), idColumnNames, 0);
        }
        ((JoinFragment)join).addCrossJoin(persister.getQualifiedTableName(), collectionName);
        ((JoinFragment)join).addCondition(collectionName, keyColumnNames, " = ?");
        if (persister.hasWhere()) {
            ((JoinFragment)join).addCondition(persister.getSQLWhereString(collectionName));
        }
        this.addFrom(elementName, elemType.getPersistentClass(), join);
    }

    String getPathAlias(String path) {
        return (String)this.pathAliases.get(path);
    }

    JoinFragment getPathJoin(String path) {
        return (JoinFragment)this.pathJoins.get(path);
    }

    void addPathAliasAndJoin(String path, String alias, JoinFragment join) {
        this.pathAliases.put(path, alias);
        this.pathJoins.put(path, join.copy());
    }

    protected int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                int i = 0;
                while (i < locs.length) {
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                    ++i;
                }
            }
            return namedParams.size();
        }
        return 0;
    }

    public Iterator iterate(Object[] values, Type[] types, RowSelection selection, Map namedParams, Map lockModes, SessionImplementor session) throws HibernateException, SQLException {
        PreparedStatement st = this.prepareQueryStatement(this.applyLocks(this.getSQLString(), lockModes, session.getFactory().getDialect()), values, types, namedParams, selection, false, session);
        ResultSet rs = this.getResultSet(st, selection, session);
        return new IteratorImpl(rs, st, session, this.getReturnTypes(), this.getScalarColumnNames());
    }

    public ScrollableResults scroll(Object[] values, Type[] types, RowSelection selection, Map namedParams, Map lockModes, SessionImplementor session) throws HibernateException, SQLException {
        PreparedStatement st = this.prepareQueryStatement(this.applyLocks(this.getSQLString(), lockModes, session.getFactory().getDialect()), values, types, namedParams, selection, true, session);
        ResultSet rs = this.getResultSet(st, selection, session);
        return new ScrollableResultsImpl(rs, st, session, this.getReturnTypes());
    }

    public static String[] concreteQueries(String query, SessionFactoryImplementor factory) {
        String[] tokens = StringHelper.split(" \n\r\f\t(),", query, true);
        if (tokens.length == 0) {
            return new String[]{query};
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        StringBuffer templateQuery = new StringBuffer(40);
        int count = 0;
        String last = null;
        int nextIndex = 0;
        String next = null;
        templateQuery.append(tokens[0]);
        int i = 1;
        while (i < tokens.length) {
            String token;
            if (!ParserHelper.isWhitespace(tokens[i - 1])) {
                last = tokens[i - 1].toLowerCase();
            }
            if (!ParserHelper.isWhitespace(token = tokens[i]) || last == null) {
                Class clazz;
                if (nextIndex <= i) {
                    nextIndex = i + 1;
                    while (nextIndex < tokens.length) {
                        next = tokens[nextIndex].toLowerCase();
                        if (!ParserHelper.isWhitespace(next)) break;
                        ++nextIndex;
                    }
                }
                if ((BEFORE_CLASS_TOKENS.contains(last) && !NOT_AFTER_CLASS_TOKENS.contains(next) || "class".equals(last)) && (clazz = QueryTranslator.getImportedClass(token, factory)) != null) {
                    String[] implementors = factory.getImplementors(clazz);
                    String placeholder = "$clazz" + count++ + "$";
                    if (implementors != null) {
                        placeholders.add(placeholder);
                        replacements.add(implementors);
                    }
                    token = placeholder;
                }
            }
            templateQuery.append(token);
            ++i;
        }
        String[] results = StringHelper.multiply(templateQuery.toString(), placeholders.iterator(), replacements.iterator());
        if (results.length == 0) {
            log.warn((Object)("no persistent classes found for query class: " + query));
        }
        return results;
    }

    Class getImportedClass(String name) {
        return QueryTranslator.getImportedClass(name, this.factory);
    }

    private static Class getImportedClass(String name, SessionFactoryImplementor factory) {
        try {
            return ReflectHelper.classForName(factory.getImportedClassName(name));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String[][] generateColumnNames(Type[] types, SessionFactoryImplementor f) throws MappingException {
        String[][] columnNames = new String[types.length][];
        int i = 0;
        while (i < types.length) {
            int span = types[i].getColumnSpan(f);
            columnNames[i] = new String[span];
            int j = 0;
            while (j < span) {
                columnNames[i][j] = QueryTranslator.scalarName(i, j);
                ++j;
            }
            ++i;
        }
        return columnNames;
    }

    public final List find(SessionImplementor session, Object[] values, Type[] types, boolean returnProxies, RowSelection selection, Map namedParams, Map lockModes) throws SQLException, HibernateException {
        return super.find(session, values, types, returnProxies, selection, namedParams, lockModes);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        Type[] scalarReturnTypes = this.getReturnTypes();
        row = this.toResultRow(row);
        if (this.hasScalars) {
            String[][] scalarColumns = this.getScalarColumnNames();
            int queryCols = scalarReturnTypes.length;
            if (this.holderClass == null && queryCols == 1) {
                return scalarReturnTypes[0].nullSafeGet(rs, scalarColumns[0], session, null);
            }
            row = new Object[queryCols];
            int i = 0;
            while (i < queryCols) {
                row[i] = scalarReturnTypes[i].nullSafeGet(rs, scalarColumns[i], session, null);
                ++i;
            }
            if (this.holderClass == null) {
                return row;
            }
        } else if (this.holderClass == null) {
            return row.length == 1 ? row[0] : row;
        }
        try {
            return this.holderConstructor.newInstance(row);
        }
        catch (Exception e) {
            throw new QueryException("could not instantiate: " + this.holderClass, e);
        }
    }

    private Object[] toResultRow(Object[] row) {
        if (this.selectLength == row.length) {
            return row;
        }
        Object[] result = new Object[this.selectLength];
        int j = 0;
        int i = 0;
        while (i < row.length) {
            if (this.includeInSelect[i]) {
                result[j++] = row[i];
            }
            ++i;
        }
        return result;
    }

    QueryJoinFragment createJoinFragment() {
        return new QueryJoinFragment(this.factory.getDialect());
    }

    void setHolderClass(Class clazz) {
        this.holderClass = clazz;
    }

    public LockMode[] getLockModes(Map lockModes) {
        HashMap nameLockModes = new HashMap();
        if (lockModes != null) {
            Iterator iter = lockModes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                nameLockModes.put(this.getAliasName((String)me.getKey()), me.getValue());
            }
        }
        LockMode[] lockModeArray = new LockMode[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            LockMode lm = (LockMode)nameLockModes.get(this.names[i]);
            if (lm == null) {
                lm = LockMode.NONE;
            }
            lockModeArray[i] = lm;
            ++i;
        }
        return lockModeArray;
    }

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sql;
        }
        if (dialect.supportsForUpdateOf()) {
            LockMode upgradeType = null;
            ForUpdateFragment updateClause = new ForUpdateFragment();
            Iterator iter = lockModes.entrySet().iterator();
            Map.Entry me = iter.next();
            String name = this.getAliasName((String)me.getKey());
            LockMode lockMode = (LockMode)me.getValue();
            if (LockMode.READ.lessThan(lockMode)) {
                updateClause.addTableAlias(name);
                if (upgradeType != null && lockMode != upgradeType) {
                    throw new QueryException("mixed LockModes");
                }
                upgradeType = lockMode;
            }
            if (upgradeType == LockMode.UPGRADE_NOWAIT && dialect.supportsForUpdateNowait()) {
                updateClause.setNowait(true);
            }
            return sql + updateClause.toFragmentString();
        }
        log.debug((Object)"dialect does not support FOR UPDATE OF");
        return sql;
    }

    protected boolean upgradeLocks() {
        return true;
    }

    protected int getCollectionOwner() {
        return this.collectionOwnerColumn;
    }

    protected void setFactory(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected boolean isCompiled() {
        return this.compiled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BEFORE_CLASS_TOKENS.add("from");
        BEFORE_CLASS_TOKENS.add(",");
        NOT_AFTER_CLASS_TOKENS.add("in");
        NOT_AFTER_CLASS_TOKENS.add("from");
        NOT_AFTER_CLASS_TOKENS.add(")");
    }
}

