/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Collections;
import java.util.Iterator;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;

public class RootClass
extends PersistentClass {
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private Property identifierProperty;
    private Value identifier;
    private Property version;
    private boolean polymorphic;
    private CacheConcurrencyStrategy cache;
    private Value discriminator;
    private boolean mutable;
    private boolean embeddedIdentifier = false;
    private boolean explicitPolymorphism;
    private Class persister;
    private boolean forceDiscriminator;

    public Property getIdentifierProperty() {
        return this.identifierProperty;
    }

    public Value getIdentifier() {
        return this.identifier;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierProperty != null;
    }

    public Value getDiscriminator() {
        return this.discriminator;
    }

    public boolean isInherited() {
        return false;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public void setPolymorphic(boolean polymorphic) {
        this.polymorphic = polymorphic;
    }

    public RootClass getRootClass() {
        return this;
    }

    public Iterator getPropertyClosureIterator() {
        return this.getPropertyIterator();
    }

    public Iterator getTableClosureIterator() {
        return Collections.singleton(this.getTable()).iterator();
    }

    public void addSubclass(Subclass subclass) {
        super.addSubclass(subclass);
        this.setPolymorphic(true);
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public Property getVersion() {
        return this.version;
    }

    public void setVersion(Property version) {
        this.version = version;
    }

    public boolean isVersioned() {
        return this.version != null;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasEmbeddedIdentifier() {
        return this.embeddedIdentifier;
    }

    public Class getPersister() {
        return this.persister;
    }

    public Table getRootTable() {
        return this.getTable();
    }

    public void setPersister(Class persister) {
        this.persister = persister;
    }

    public PersistentClass getSuperclass() {
        return null;
    }

    public Value getKey() {
        return this.getIdentifier();
    }

    public void setDiscriminator(Value discriminator) {
        this.discriminator = discriminator;
    }

    public void setEmbeddedIdentifier(boolean embeddedIdentifier) {
        this.embeddedIdentifier = embeddedIdentifier;
    }

    public void setExplicitPolymorphism(boolean explicitPolymorphism) {
        this.explicitPolymorphism = explicitPolymorphism;
    }

    public void setIdentifier(Value identifier) {
        this.identifier = identifier;
    }

    public void setIdentifierProperty(Property identifierProperty) {
        this.identifierProperty = identifierProperty;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void setCache(CacheConcurrencyStrategy cache) {
        this.cache = cache;
    }

    public boolean isForceDiscriminator() {
        return this.forceDiscriminator;
    }

    public void setForceDiscriminator(boolean forceDiscriminator) {
        this.forceDiscriminator = forceDiscriminator;
    }
}

