/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.MemberReferenceScanner;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MemberReferenceCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public MemberReferenceCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName;
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        if (leaf instanceof MemberReferenceTree) {
            int indexInClass;
            int indexInSource = MemberReferenceScanner.indexOfMemberReferenceTree(path, leaf);
            boolean b = this.loc.isBytecodeOffset() ? indexInSource == (indexInClass = MemberReferenceScanner.getMemberReferenceIndex(this.methodName, this.loc.offset).intValue()) : indexInSource == this.loc.index;
            return b;
        }
        boolean b = this.isSatisfiedBy(path.getParentPath());
        return b;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.METHOD_REFERENCE;
    }

    public String toString() {
        return "MemberReferenceCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

