/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.afu.annotator.scanner.CommonScanner;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

public class CastScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static String prevMethodName = null;
    private static int prevOffset = -1;
    private static int nestLevels = 0;
    private static Map<String, List<Integer>> methodNameToCastOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfCastTree(TreePath origpath, Tree tree) {
        TreePath path = TreePathUtil.findCountingContext(origpath);
        if (path == null) {
            return -1;
        }
        CastScanner lvts = new CastScanner(tree);
        lvts.scan(path, null);
        return lvts.index;
    }

    private CastScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
            return null;
        }
        return (Void)super.visitTypeCast(node, null);
    }

    public static void addCastToMethod(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToCastOffsets.get(methodName);
        if (offsetList == null) {
            offsetList = new ArrayList<Integer>();
            methodNameToCastOffsets.put(methodName, offsetList);
        }
        if (methodName.equals(prevMethodName) && offset - prevOffset == 3) {
            offsetList.add(offsetList.size() - ++nestLevels, offset);
        } else {
            nestLevels = 0;
            offsetList.add(offset);
        }
        prevMethodName = methodName;
        prevOffset = offset;
    }

    public static Integer getMethodCastIndex(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToCastOffsets.get(methodName);
        if (offsetList == null) {
            return -1;
        }
        return offsetList.indexOf(offset);
    }
}

