/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.google.common.base.Throwables;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;

public class TreePathUtil {
    private static final MethodHandle GET_END_POS_HANDLE = TreePathUtil.getEndPosMethodHandle();

    private TreePathUtil() {
        throw new Error("Do not instantiate.");
    }

    public static boolean hasClassKind(Tree tree) {
        Tree.Kind kind = tree.getKind();
        return kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || kind == Tree.Kind.ANNOTATION_TYPE;
    }

    public static TreePath findCountingContext(TreePath path) {
        while (path != null) {
            if (path.getLeaf() instanceof MethodTree || TreePathUtil.isFieldInit(path) || TreePathUtil.isInitBlock(path)) {
                return path;
            }
            path = path.getParentPath();
        }
        return path;
    }

    public static TreePath findEnclosingClass(TreePath path) {
        while (!TreePathUtil.hasClassKind(path.getLeaf()) || path.getParentPath().getLeaf() instanceof NewClassTree) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static TreePath findEnclosingMethod(TreePath path) {
        while (!(path.getLeaf() instanceof MethodTree)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isFieldInit(TreePath path) {
        return path.getLeaf() instanceof VariableTree && path.getParentPath() != null && TreePathUtil.hasClassKind(path.getParentPath().getLeaf());
    }

    public static TreePath findEnclosingFieldInit(TreePath path) {
        while (!TreePathUtil.isFieldInit(path)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isInitBlock(TreePath path, boolean isStatic) {
        return TreePathUtil.isInitBlock(path) && ((BlockTree)path.getLeaf()).isStatic() == isStatic;
    }

    public static boolean isInitBlock(TreePath path) {
        return path.getParentPath() != null && TreePathUtil.hasClassKind(path.getParentPath().getLeaf()) && path.getLeaf() instanceof BlockTree;
    }

    public static TreePath findEnclosingInitBlock(TreePath path, boolean isStatic) {
        while (!TreePathUtil.isInitBlock(path, isStatic)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isStaticInit(TreePath path) {
        return TreePathUtil.isInitBlock(path, true);
    }

    public static TreePath findEnclosingStaticInit(TreePath path) {
        while (!TreePathUtil.isStaticInit(path)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isInstanceInit(TreePath path) {
        return TreePathUtil.isInitBlock(path, false);
    }

    public static TreePath findEnclosingInstanceInit(TreePath path) {
        while (!TreePathUtil.isInstanceInit(path)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean hasConstructor(ClassTree ct) {
        int ctPos = -1;
        for (Tree tree : ct.getMembers()) {
            MethodTree method;
            if (!(tree instanceof MethodTree) || !(method = (MethodTree)tree).getName().contentEquals("<init>")) continue;
            if (ctPos == -1) {
                ctPos = TreePathUtil.classTreePos(ct);
            }
            int mPos1 = ((JCTree.JCMethodDecl)method).getStartPosition();
            int mPos2 = ((JCTree)((Object)method.getBody())).getStartPosition();
            if (mPos1 <= ctPos || mPos1 == mPos2) continue;
            return true;
        }
        return false;
    }

    private static int classTreePos(ClassTree ct) {
        ModifiersTree mods = ct.getModifiers();
        int ctPos = ((JCTree)((Object)mods)).getStartPosition() + mods.toString().length() + 1;
        Tree extendsClause = ct.getExtendsClause();
        if (extendsClause != null) {
            ctPos = Math.max(ctPos, ((JCTree)extendsClause).getStartPosition());
        }
        for (Tree tree : ct.getImplementsClause()) {
            ctPos = Math.max(ctPos, ((JCTree)tree).getStartPosition());
        }
        return ctPos;
    }

    public static String getBinaryName(TreePath path) {
        String result = "";
        for (Tree t : path) {
            switch (t.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    ClassTree ct = (ClassTree)t;
                    String className = ct.getSimpleName().toString();
                    result = result.isEmpty() ? className : className + "$" + result;
                    break;
                }
                case METHOD: {
                    result = "1" + result;
                    break;
                }
                case COMPILATION_UNIT: {
                    CompilationUnitTree cut = (CompilationUnitTree)t;
                    ExpressionTree pkgExp = cut.getPackageName();
                    if (pkgExp == null) {
                        return result;
                    }
                    return pkgExp.toString() + "." + result;
                }
            }
        }
        throw new Error("unreachable");
    }

    public static int getEndPosition(Tree tree, CompilationUnitTree unit) {
        try {
            return GET_END_POS_HANDLE.invokeExact((JCTree)tree, (JCTree.JCCompilationUnit)unit);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle getEndPosMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return MethodHandles.dropArguments(lookup.findVirtual(JCTree.class, "getEndPosition", MethodType.methodType(Integer.TYPE)), 1, new Class[]{JCTree.JCCompilationUnit.class});
        }
        catch (ReflectiveOperationException e1) {
            try {
                return MethodHandles.filterArguments(lookup.findVirtual(JCTree.class, "getEndPosition", MethodType.methodType(Integer.TYPE, Class.forName("com.sun.tools.javac.tree.EndPosTable"))), 1, lookup.findVarHandle(JCTree.JCCompilationUnit.class, "endPositions", Class.forName("com.sun.tools.javac.tree.EndPosTable")).toMethodHandle(VarHandle.AccessMode.GET));
            }
            catch (ReflectiveOperationException e2) {
                e2.addSuppressed(e1);
                throw new LinkageError(e2.getMessage(), e2);
            }
        }
    }
}

