/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io.classfile;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class MethodCodeOffsetAdapter
extends MethodVisitor {
    private final ClassReader classReader;
    private int codeStart = 0;
    private int attrCount = 0;
    private int offset;
    private int previousOffset;

    public MethodCodeOffsetAdapter(ClassReader classReader, MethodVisitor methodVisitor, int start) {
        super(524288, methodVisitor);
        String attrName;
        char[] buf = new char[classReader.header];
        this.classReader = classReader;
        this.codeStart = start;
        this.attrCount = classReader.readUnsignedShort(this.codeStart + 6);
        this.codeStart += 8;
        while (this.attrCount > 0 && !"Code".equals(attrName = classReader.readUTF8(this.codeStart, buf))) {
            this.codeStart += 6 + classReader.readInt(this.codeStart + 2);
            --this.attrCount;
        }
    }

    private int readInt(int i) {
        return this.classReader.readInt(this.codeStart + i);
    }

    private void advance(int i) {
        this.previousOffset = this.offset;
        this.offset += i;
    }

    public int getCodeStart() {
        return this.codeStart;
    }

    public int getPreviousOffset() {
        return this.previousOffset;
    }

    public int getCurrentOffset() {
        return this.offset;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        this.advance(3);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.advance(3);
    }

    @Override
    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.advance(1);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.advance(opcode == 17 ? 3 : 2);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name, descriptor, bsm, bsmArgs);
        this.advance(5);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.advance(3);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.advance(2);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.previousOffset = this.offset;
        this.offset += 8 - (this.offset - this.codeStart & 3);
        this.offset += 4 + 8 * this.readInt(this.offset);
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        super.visitMethodInsn(opcode, owner, name, descriptor);
        this.advance(opcode == 185 ? 5 : 3);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        this.advance(opcode == 185 ? 5 : 3);
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor, int dims) {
        super.visitMultiANewArrayInsn(descriptor, dims);
        this.advance(4);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.previousOffset = this.offset;
        this.offset += 8 - (this.offset - this.codeStart & 3);
        this.offset += 4 * (this.readInt(this.offset + 4) - this.readInt(this.offset) + 3);
    }

    @Override
    public void visitTypeInsn(int opcode, String descriptor) {
        super.visitTypeInsn(opcode, descriptor);
        this.advance(3);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.advance(var < 4 ? 1 : 2);
    }

    @Override
    public void visitEnd() {
        this.offset = -1;
    }
}

